/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.test.appserver;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.util.UserContext;
import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.ceutils.ConnectionPoints;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.Configuration;
import filenet.ws.listener.utils.WSDLManager;
import filenet.ws.utils.WSConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.SimpleTimeZone;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.omg.CORBA.ORB;

public class PEAPIServletTest
extends HttpServlet {
    private static final long serialVersionUID = 256L;
    protected static Logger logger = Logger.getLogger("filenet.pe.test.appserver");
    private static final String m_className = "PEAPIServletTest";
    private static final String PROPVALUE_NOTAVAIL = "N/A";
    private static final String PEAPITEST_WF_NAME = "PEAPITestWF";
    private static final String PATH_ROSTER = "/roster/";
    private static final String PATH_QUEUE = "/queue/";
    private static final String PATH_WC = "/wc/";
    private static final String PATH_LAUNCH = "/launch/";
    private static final String PATH_TRANSFER_PEAPITESTWF = "/transfer/PEAPITestWF";
    private static final String PATH_ADMIN_CLASSLOADER = "/admin/classloader";
    private static final String PATH_ADMIN_SETPROPERTY = "/admin/setproperty";
    private static final String PARAM_USER = "user";
    private static final String PARAM_PW = "pw";
    private static final String PARAM_CP = "cp";
    private static final String PARAM_CEURI = "ceuri";
    private static final String PARAM_NITEMS = "nitems";
    private static final String PARAM_QUERYFLAGS = "queryflags";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_CONCURRENT = "concurrent";
    private static final String PARAM_FETCHTYPE = "fetchtype";
    private static final String PARAM_OPTIMIZE = "optimize";
    private static final String PARAM_WOBNUM = "wobnum";
    private static final String PARAM_NOWSI = "noWSI";
    private static final String PARAM_WANTXML = "wantXML";
    private static final String PARAM_DEFAULT_ROSTER = "DefaultRoster";
    private static final String PARAM_DEFAULT_QUEUE = "Inbox(0)";
    private static final String PARAM_DEFAULT_INDEXNAME = "F_WobNum";
    private static String LF = "\r\n";
    private static String GENERIC_HELP_STRING = "\tPathinfo:" + LF + "\t\t/admin/classloader == checking out a class where it's loaded etc." + LF + "\t\t/roster/dispatch == dispatch work objects from roster -- the work item should have data fields: peapiString, peapiDate, peapiInteger" + LF + "\t\t/roster/query == query for roster elements -- display the XML versions" + LF + "\t\t/queue/dispatch == dispatch work objects from queue -- the work item should have data fields: peapiString, peapiDate, peapiInteger" + LF + "\t\t/queue/query == query the queue elements -- display the XML versions" + LF + "\t\t/wc/<workclassName>?wf    -- display the runtime XML for the workclass" + LF + "\t\t/launch/<workclassName> -- launch the workclass -- again the work class should have data fields: peapiString, peapiDate, peapiInteger" + LF + "\t\t/transfer/" + "PEAPITestWF" + " -- transfer the test workflow if not present" + LF + LF + "\tQuery string:" + LF + "\t\tRequired for all paths:  user=xx&pw=xx&cp=xxx" + LF + "\t\t\tAlso optional ceuri, e.g. ceuri=http://hqamber:9080/wsi/FNCEWS40DIME" + LF + "\t\t\tSet noWSI=true to use the normal FileNetP8 route.  By default we want to use FileNetP8WSI, thus will require packaging with CEAPI/NST no WASP!" + LF + "\t\tDepending on the path, following are optional parameters, default values specified below" + LF + "\t\tfor launch:  nitems=#" + LF + "\t\t\tnitems=#, # of items to create/launch, default is 3" + LF + "\t\tfor roster or queue/dispatch: nitems=#&name=xxx&concurrent=true&optimize=true&wobnum=xxx" + LF + "\t\t\tnitems = # of items to dispatch, default is 5 or whatever is left in the roster." + LF + "\t\t\tqueryflags = # (queue query only)" + LF + "\t\t\tname = roster name or queue name, default is DefaultRoster or Inbox(0)" + LF + "\t\t\tconcurrent = true --> spawn nitems thread to dispatch the work object at the same time" + LF + "\t\t   optimize = true --> to exercise the more efficient way of dispatching.." + LF + "\t\t   wobnum=xxx, dispatch the given work object -- when this is present, nitems is set to 1, no threading" + LF + "\t\tfor roster or queue/query:  nitems=#&name=xxx&fetchtype=xxx&wobnum=xxx" + LF + "\t\t\tnitems = # of items to display, default is 50." + LF + "\t\t\tname = roster or queue name, default is DefaultRoster or Inbox(0)" + LF + "\t\t   fetchtype=workbobject, to retrieve as VWWorkObject, instead of VWRosterElement or VWQueueElement" + LF + "\t\t             in the case of queue/query, can specify fetchtype=stepelement as well" + LF + "\t\t   wobnum=xxx, querying for the workobject with the wobnum specified." + LF + "\t\t   wantXML=xxx, if present, then returns the queueelements.toXML()." + LF + LF + "For example: " + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/listqueues?cp=cp&user=usr&pw=pw" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/listcp?user=intgpeadmin&pw=pw&ceuri=http://hq-intgwin8:8080/wsi/FNCEWS40DIME" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/wc/" + "PEAPITestWF" + "?wf&cp=cp&user=peadmin&pw=pw" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/launch/" + "PEAPITestWF" + "?nitems=10&cp=cp&user=peadmin&pw=pw" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/roster/query?cp=cp&user=peadmin&pw=pw" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/roster/query?cp=cp&user=peadmin&pw=pw&fetchtype=stepelement" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/roster/query?cp=cp&user=peadmin&pw=pw&fetchtype=workobject" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/queue/query?cp=cp&user=peadmin&pw=pw&fetchtype=stepelement" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/queue/query?cp=cp&user=peadmin&pw=pw&fetchtype=workobject" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/queue/query?cp=cp&user=peadmin&pw=pw" + LF + "\t\thttp://localhost:8080/PEAPITest/peapitest/queue/dispatch?cp=cmephpi5_600&user=PEAdmin&pw=pw&wobnum=9E8CCA220A9511DDBDE5001B789FC06B&fetchtype=workobject" + LF;
    protected static String g_CEURI = null;
    protected static String g_CP = null;
    protected static String g_USER = null;
    private static final String CLASS_NAME = "classname";
    private static String ORBClassName = null;
    private static final int LIST_CP = 0;
    private static final int LIST_QUEUES = 1;
    private static final int LIST_ROSTERS = 2;
    private static final int LIST_WC = 3;
    private static final int LIST_WC2 = 4;
    private static final String[] G_LIST_PATHS;
    private static final String[] G_LIST_PATHS_HELP;
    private static final String TEST_WORKFLOW_STRING;
    private static final String[] WFFIELD_PEAPI_FIELDS;
    private static int WFFIELD_PEAPI_FIELDS_NUM;
    private static final int USE_ROSTER = 0;
    private static final int USE_QUEUE = 1;
    private static final String[] FUNCTIONS;
    private static final int FUNCTION_QUERY = 0;
    private static final int FUNCTION_DISPATCH = 1;
    private static final int FUNCTION_INVALID = -1;
    private static final String BASE_INDENT = "";
    private static final String BUMP_INDENT = "\t";
    private static final String WORKFLOW_INDENT = "";
    private static final String FIELD_INDENT = "\t";
    private static final String UTC_ISO_DateMask = "yyyyMMdd'T'HHmmss'Z'";
    private static final SimpleDateFormat sdf;
    private static SimpleTimeZone pdt;
    private static final Long NO_DATE;

    private static final void setPrivilegedSystemProperty(String propName, String propValue) {
        final String fpropName = propName;
        final String fValue = propValue;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (fValue != null) {
                    System.setProperty(fpropName, fValue);
                } else {
                    System.getProperties().remove(fpropName);
                }
                return null;
            }
        });
    }

    private static void SetSystemProperty(String propName, String propValue) {
        if (propValue == null || propName == null || System.getProperty(propName) != null || propValue.equals(PROPVALUE_NOTAVAIL)) {
            return;
        }
        if (logger.isFinest()) {
            logger.finest("PEAPIServletTest.SetSystemProperty: " + propName + "=" + propValue);
        }
        PEAPIServletTest.setPrivilegedSystemProperty(propName, propValue);
    }

    private static String adjustValue(String propValue) {
        if (propValue == null || propValue.equals(PROPVALUE_NOTAVAIL)) {
            return null;
        }
        return propValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String m_method = "init";
        try {
            logger.entering(m_className, "init");
            ServletConfig config = this.getServletConfig();
            g_CEURI = PEAPIServletTest.adjustValue(config.getInitParameter(PARAM_CEURI));
            g_CP = PEAPIServletTest.adjustValue(config.getInitParameter(PARAM_CP));
            g_USER = PEAPIServletTest.adjustValue(config.getInitParameter(PARAM_USER));
            PEAPIServletTest.SetSystemProperty("filenet.pe.peorb.pool.guard", config.getInitParameter("filenet.pe.peorb.pool.guard"));
            PEAPIServletTest.SetSystemProperty("filenet.pe.peorb.pool.min", config.getInitParameter("filenet.pe.peorb.pool.min"));
            PEAPIServletTest.SetSystemProperty("filenet.pe.peorb.pool.max", config.getInitParameter("filenet.pe.peorb.pool.max"));
        }
        catch (Exception e) {
            logger.throwing(m_className, "init", e);
            logger.severe(m_className, "init", e.getMessage());
        }
        finally {
            logger.exiting(m_className, "init");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String m_method = "doGet";
        logger.entering(m_className, "doGet");
        String ceuri = null;
        try {
            boolean hasVWSession;
            String queryString = request.getQueryString();
            ceuri = this.getCEURI(request);
            String s = request.getPathInfo();
            String pathInfo = "";
            if (s != null) {
                pathInfo = WSConstants.UTF8Decode(s);
            }
            if (pathInfo.startsWith(PATH_ADMIN_CLASSLOADER)) {
                this.processClassLoaderRequest(request, response);
                return;
            }
            if (pathInfo.startsWith(PATH_ADMIN_SETPROPERTY)) {
                this.processSetProperty(request, response);
            }
            VWSession curVWSession = null;
            String user = this.getStringParameter(request, PARAM_USER, g_USER);
            String pw = this.getStringParameter(request, PARAM_PW, null);
            String cpName = this.getStringParameter(request, PARAM_CP, g_CP);
            if (request.getParameter(PARAM_NOWSI) == null && pw != null) {
                Connection conn = Factory.Connection.getConnection((String)ceuri);
                Subject subject = UserContext.createSubject((Connection)conn, (String)user, (String)pw, (String)"FileNetP8WSI");
                UserContext uc = UserContext.get();
                uc.pushSubject(subject);
            }
            if (user != null && pw != null && cpName != null && ceuri != null) {
                curVWSession = new VWSession();
                curVWSession.setBootstrapCEURI(ceuri);
                if (request.getParameter(PARAM_NOWSI) != null) {
                    curVWSession.logon(user, pw, cpName);
                } else {
                    curVWSession.logon(cpName);
                }
            }
            boolean bl = hasVWSession = curVWSession != null;
            if (pathInfo != null) {
                pathInfo = pathInfo.trim();
            }
            if (pathInfo == null || pathInfo.length() == 0 || !hasVWSession) {
                this.printRequestInfo(request, response, null);
                return;
            }
            if (pathInfo.startsWith(PATH_WC)) {
                boolean wantWF;
                if ((pathInfo = pathInfo.substring(PATH_WC.length())).length() == 0) {
                    throw new MalformedURLException(pathInfo);
                }
                int dtdIndex = pathInfo.lastIndexOf(".dtd");
                if (dtdIndex > 0) {
                    int jj = pathInfo.lastIndexOf(47, dtdIndex);
                    String dtdName = pathInfo.substring(jj + 1);
                    this.genDTD(response, dtdName);
                    return;
                }
                boolean bl2 = wantWF = queryString != null && queryString.startsWith("wf");
                if (hasVWSession) {
                    this.getWorkClassWSDLorWF(request, response, pathInfo, wantWF, curVWSession);
                } else {
                    this.printRequestInfo(request, response, null);
                    return;
                }
            }
            if (pathInfo.startsWith("/list")) {
                this.listFunctions(pathInfo, request, response, curVWSession, ceuri, cpName);
                return;
            }
            if (!hasVWSession) {
                this.printRequestInfo(request, response, null);
                return;
            }
            if (pathInfo.startsWith(PATH_TRANSFER_PEAPITESTWF)) {
                this.transferTestWorkflowDefinition(request, response, curVWSession);
            }
            if (pathInfo.startsWith(PATH_LAUNCH)) {
                pathInfo = pathInfo.substring(PATH_LAUNCH.length());
                this.launchFunction(pathInfo, request, response, curVWSession, cpName);
            }
            boolean rosterFunction = pathInfo.startsWith(PATH_ROSTER);
            boolean queueFunction = pathInfo.startsWith(PATH_QUEUE);
            if (rosterFunction || queueFunction) {
                pathInfo = pathInfo.substring((rosterFunction ? PATH_ROSTER : PATH_QUEUE).length());
                this.doFunctions(rosterFunction ? 0 : 1, pathInfo, request, response, curVWSession, user, pw, cpName, ceuri);
            }
        }
        catch (Throwable e) {
            this.reportTroubleInGet(e, request, response);
            return;
        }
        finally {
            logger.exiting(m_className, "doGet");
        }
    }

    private int getIntParameter(HttpServletRequest request, String paramName, int defaultValue) {
        int res = defaultValue;
        String s = request.getParameter(paramName);
        if (s != null) {
            try {
                res = Integer.parseInt(s);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return res;
    }

    private String getStringParameter(HttpServletRequest request, String paramName, String defaultValue) {
        String s = request.getParameter(paramName);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCEURI(HttpServletRequest request) throws Exception {
        String s = null;
        String m_method = "getCEURI";
        s = request.getParameter(PARAM_CEURI);
        if (s == null) {
            ServletContext context = this.getServletContext();
            InputStream configStream = null;
            try {
                logger.entering(m_className, "getCEURI");
                configStream = context.getResourceAsStream("/WEB-INF/WcmApiConfig.properties");
                if (configStream == null) {
                    logger.severe(m_className, "getCEURI", "Cannot find WcmApiConfig.properties..");
                }
                s = Configuration.GetCEURI(configStream, null);
            }
            catch (Exception e) {
                logger.throwing(m_className, "getCEURI", e);
            }
            finally {
                if (configStream != null) {
                    try {
                        configStream.close();
                    }
                    catch (Exception e) {}
                }
                logger.exiting(m_className, "getCEURI");
            }
        }
        if (s == null) {
            s = g_CEURI;
        }
        if (s == null) {
            throw new Exception("No CEURI was defined..");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTroubleInGet(Throwable exception, HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            String s = VWException.DescribeThrowableAndItsCauseWithStackFrames(exception, 100);
            writer = response.getWriter();
            response.setContentType("text/plain");
            writer.println("Exception - " + s);
            writer.println("---------------------------------");
            writer.println(this.getRequestInfoForTracing(request, null));
        }
        catch (Exception e) {
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getRequestInfoForTracing(HttpServletRequest request, StringBuffer buf) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        String newsep = "\r\n";
        String version = PEAPIServletTest.getVersion("filenet.vw.toolkit.utils.VWBuildStamp");
        buf.append("\r\n").append("\r\n").append("=== version: ").append("\r\n").append(version);
        buf.append("\r\n").append("Method: ").append(request.getMethod());
        buf.append("\r\n").append("Request URI: ").append(request.getRequestURI());
        buf.append("\r\n").append("Protocol: ").append(request.getProtocol());
        if (request.getPathInfo() != null) {
            buf.append("\r\n").append("PathInfo: ").append(WSConstants.UTF8Decode(request.getPathInfo()));
        }
        buf.append("\r\n").append("ContextPath: ").append(request.getContextPath());
        buf.append("\r\n").append("PathTranslated: ").append(request.getPathTranslated());
        buf.append("\r\n").append("ServletPath: ").append(request.getServletPath());
        buf.append("\r\n").append("QueryString: ").append(request.getQueryString());
        buf.append("\r\n").append("Remote Address: ").append(request.getRemoteAddr());
        buf.append("\r\n").append("\r\n").append("=== Headers Information: ");
        Enumeration headerNamesEnum = request.getHeaderNames();
        if (headerNamesEnum != null) {
            while (headerNamesEnum.hasMoreElements()) {
                String headerName = (String)headerNamesEnum.nextElement();
                buf.append("\r\n").append(headerName).append("=");
                Enumeration headerValuesEnum = request.getHeaders(headerName);
                if (headerValuesEnum == null) continue;
                boolean moreToCome = false;
                do {
                    buf.append(headerValuesEnum.nextElement());
                    moreToCome = headerValuesEnum.hasMoreElements();
                    if (!moreToCome) continue;
                    buf.append(",");
                } while (moreToCome);
            }
        }
        buf.append("\r\n").append("\r\n").append("=== Parameter Information: ");
        Enumeration paramNamesEnum = request.getParameterNames();
        if (paramNamesEnum != null) {
            while (paramNamesEnum.hasMoreElements()) {
                String paramName = (String)paramNamesEnum.nextElement();
                buf.append("\r\n").append(paramName).append("=").append(Logger.asString(request.getParameterValues(paramName)));
            }
        }
        buf.append("\r\n").append("\r\n").append("=== Request Attribute Information: ");
        Enumeration attributeNames = request.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                String attribName = (String)attributeNames.nextElement();
                buf.append("\r\n").append(attribName).append("=").append(Logger.asString(request.getAttribute(attribName)));
            }
        }
        try {
            buf.append("\r\n").append(Logger.traceProperties("=== PEAPIServletTest "));
        }
        catch (Throwable t) {
            // empty catch block
        }
        int nLists = G_LIST_PATHS.length;
        buf.append("\r\n").append("\r\n").append("================ USAGE of the servlet URLs should be UTF-8 encoded");
        for (int i = 0; i < nLists; ++i) {
            buf.append("\r\n").append(G_LIST_PATHS[i]).append(G_LIST_PATHS_HELP[i]);
        }
        buf.append("\r\n");
        buf.append("\r\n").append(GENERIC_HELP_STRING);
        return buf.toString();
    }

    private void printRequestInfo(HttpServletRequest request, HttpServletResponse response, StringBuffer buf) throws IOException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        out.println("---------------------------------");
        out.println(this.getRequestInfoForTracing(request, buf));
    }

    private void processSetProperty(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("<SetPropertyCall ");
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String propName = (String)names.nextElement();
            String propValue = request.getParameter(propName);
            PEAPIServletTest.setPrivilegedSystemProperty(propName, propValue);
            buf.append(" ").append(propName).append("=\"").append(XMLHelper.toXMLString(propValue)).append("\"");
        }
        buf.append("/>");
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void processClassLoaderRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String error = null;
        String classLocation = null;
        String className = request.getParameter(CLASS_NAME);
        String classLoaderInfo = null;
        if (className != null && (className = className.trim()).length() != 0) {
            try {
                ProtectionDomain pd = Class.forName(className).getProtectionDomain();
                if (pd != null) {
                    CodeSource cs = pd.getCodeSource();
                    if (cs != null) {
                        classLocation = cs.toString();
                    } else {
                        error = "No CodeSource found!";
                    }
                    classLoaderInfo = Class.forName(className).getClassLoader().toString();
                } else {
                    error = "No ProtectionDomain found!";
                }
            }
            catch (Throwable t) {
                error = t.toString();
                this.log("error=" + t, t);
            }
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Servlet Container Class Finder</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"#d1d7b3\">");
        out.println("<h2><font color=\"#0000a0\">Servlet Container Class Finder</font></h2>");
        out.println("<p><font color=\"#000000\">Enter the fully-qualified name of a Java class");
        out.println("(e.g. org.apache.oro.text.regex.Perl5Compiler) in the field below. The");
        out.println("servlet will attempt to load the class and, if successful, query the");
        out.println("classes' <em>java.security.CodeSource</em> for the location of the class");
        out.println("using the following methods: <pre>");
        out.println("Class.forName(className).getProtectionDomain().getCodeSource()");
        out.println("</pre> </font></p>");
        out.println("<form method=\"get\" action=\"" + request.getRequestURI() + "\">");
        out.println("<p>Class Name: <input type=\"text\" name=\"classname\"");
        out.println("\tvalue=\"" + (className != null ? className : "") + "\" size=\"40\" /> <input type=\"submit\"");
        out.println("\tvalue=\"Submit\" /></p>");
        out.println("</form>");
        if (classLocation != null || error != null) {
            out.println("<table border=\"1\" bgcolor=\"#8080c0\">");
            out.println("\t<caption align=\"top\"><font color=\"#000000\">Search Results</font></caption>");
            out.println("\t<tbody>");
            out.println("\t\t<tr>");
            out.println("\t\t\t<td align=\"right\"><font color=\"#000000\">Class Name:</font></td>");
            out.println("\t\t\t<td><font color=\"#000000\">" + className + "</font></td>");
            out.println("\t\t</tr>");
            out.println("\t\t<tr>");
            if (error != null) {
                out.println("\t\t\t<td align=\"right\"><font color=\"#a00000\">Error:</font></td>");
                out.println("\t\t\t<td><font color=\"#a00000\">" + error + "</font></td>");
            } else {
                out.println("\t\t\t<td align=\"right\"><font color=\"#000000\">Class Location:</font></td>");
                out.println("\t\t\t<td><font color=\"#000000\">" + classLocation + "</font></td>");
                out.println("\t\t</tr>");
                out.println("\t\t<tr>");
                out.println("\t\t\t<td align=\"right\"><font color=\"#000000\">Class Loader:</font></td>");
                out.println("\t\t\t<td><font color=\"#000000\">" + classLoaderInfo + "</font></td>");
            }
            out.println("\t\t</tr>");
            out.println("\t</tbody>");
            out.println("</table>");
        }
        out.println("</body>");
        out.println("</html>");
        out.flush();
        out.close();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   21 Apr 2008 14:17:50  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.7  $";
    }

    private static String getVersion(String className) {
        if (className != null) {
            try {
                int nFields;
                Class<?> cls = Class.forName(className);
                Object obj = cls.newInstance();
                Field[] fields = cls.getFields();
                StringBuffer buf = new StringBuffer(512);
                buf.append(className).append("\n");
                int n = nFields = fields == null ? 0 : fields.length;
                while (--nFields > 0) {
                    String fieldName = fields[nFields].getName();
                    if (fieldName.equals("buildDateMask")) continue;
                    buf.append(fields[nFields].getName()).append("=").append(fields[nFields].get(obj)).append("\n");
                }
                buf.append("ORBClassName=").append(ORBClassName);
                return buf.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWorkClassWSDLorWF(HttpServletRequest request, HttpServletResponse response, String workClassPath, boolean wantWF, VWSession curVWSession) throws Throwable {
        String m_method = "getWorkClass(WSDL)orWF";
        if (wantWF) {
            m_method = "getWorkClassWSDLor(WF)";
        }
        logger.entering(m_className, m_method);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, workClassPath);
        }
        try {
            int jj;
            int len = workClassPath.length();
            for (jj = 0; jj < len && (workClassPath.charAt(jj) == ' ' || workClassPath.charAt(jj) == '/'); ++jj) {
            }
            if (jj == len) {
                throw new MalformedURLException();
            }
            if (jj > 0) {
                workClassPath = workClassPath.substring(jj);
            }
            int workspaceId = -1;
            int ii = workClassPath.lastIndexOf("/");
            if (ii > 0) {
                String s = workClassPath.substring(ii + 1);
                workClassPath = workClassPath.substring(0, ii);
                if (s.length() > 0) {
                    try {
                        workspaceId = Integer.parseInt(s);
                    }
                    catch (Exception e) {
                        throw new VWException("filenet.ws.listener.http.PEAPIServletTest.invalidWorkSpaceId", "Invalid work space id specified {0}.", s);
                    }
                }
            }
            response.setContentType("text/xml; charset=UTF-8");
            response.getWriter().println(WSDLManager.genWorkClassWSDLorWF(workClassPath, workspaceId, null, wantWF, this.getStringParameter(request, PARAM_CP, g_CP), curVWSession));
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genDTD(HttpServletResponse response, String dtdName) throws Throwable {
        String dtdString = "filenet/vw/api/" + dtdName;
        String m_method = "genDTD:" + dtdString;
        logger.entering(m_className, m_method);
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(dtdString);
            int size = inStream.available();
            if (size > 0) {
                response.setContentType("text/plain");
                outStream = response.getOutputStream();
                for (int i = 0; i < size; ++i) {
                    outStream.write(inStream.read());
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Finished writing " + Integer.toString(size) + " bytes");
                }
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {}
            }
            logger.exiting(m_className, m_method);
        }
    }

    private void listFunctions(String pathInfo, HttpServletRequest request, HttpServletResponse response, VWSession curVWSession, String ceuri, String cpName) throws Throwable {
        int function = 3;
        int nLists = G_LIST_PATHS.length;
        for (int i = 0; i < nLists; ++i) {
            if (!pathInfo.equals(G_LIST_PATHS[i])) continue;
            function = i;
            break;
        }
        if (function != 0 && curVWSession == null) {
            throw new Exception("No VWSession!! Potentially missing credential information!");
        }
        switch (function) {
            case 0: {
                this.genCPInfo(response, ceuri, request.getParameter(PARAM_NOWSI) == null ? null : this.getStringParameter(request, PARAM_USER, g_USER), this.getStringParameter(request, PARAM_PW, null));
                return;
            }
            case 1: {
                this.genQueuesInfo(response, curVWSession);
                return;
            }
            case 2: {
                this.genRostersInfo(response, cpName, curVWSession);
                return;
            }
            case 3: 
            case 4: {
                this.genWorkClassesInfo(response, curVWSession);
                return;
            }
        }
    }

    private void genCPInfo(HttpServletResponse response, String ceuri, String name, String pw) throws Throwable {
        String m_method = "genCPInfo";
        PrintWriter out = null;
        try {
            ConnectionPoint[] cps = ConnectionPoints.GetConnectionPoints(ceuri, name, pw);
            response.setContentType("text/html");
            out = response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Connection Point information</title>");
            out.println("</head>");
            int nCps = cps == null ? 0 : cps.length;
            out.println("<body>");
            out.println("<p>Number of defined connection points = " + Integer.toString(nCps) + "</p>");
            while (nCps > 0) {
                out.println("<br>" + cps[--nCps]);
            }
            out.println("</body></html>");
        }
        catch (Throwable t) {
            logger.severe(m_className, "genCPInfo", t.getMessage());
            throw t;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void GetGenericInfo(VWSession curVWSession, String startTag, StringBuffer buf) throws VWException {
        buf.append(startTag).append(" cp=\"").append(XMLHelper.toXMLString(curVWSession.getRouterURL())).append("\" system=\"").append(XMLHelper.toXMLString(curVWSession.getServerName())).append("\" region=\"").append(curVWSession.getIsolatedRegion()).append("\" ");
    }

    private void genWorkClassesInfo(HttpServletResponse response, VWSession curVWSession) throws Throwable {
        String m_method = "genWorkClassesInfo";
        String CALL_START_TAG = "<ListWorkClassesCall";
        String CALL_END_TAG = "\n</ListWorkClassesCall>";
        StringBuffer buf = new StringBuffer();
        PEAPIServletTest.GetGenericInfo(curVWSession, "<ListWorkClassesCall", buf);
        try {
            TimingInfo timer = new TimingInfo(null);
            String[] theList = curVWSession.fetchWorkClassNames(false);
            String sTiming = timer.elapsed();
            int nItems = theList == null ? 0 : theList.length;
            buf.append("nitems=\"").append(nItems).append("\" ").append(sTiming).append(">");
            for (int i = 0; i < nItems; ++i) {
                buf.append("\n").append("<WorkClass name=\"").append(XMLHelper.toXMLString(theList[i])).append("\"/>");
            }
            buf.append("\n</ListWorkClassesCall>");
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            buf.append(" Exception=\"").append(XMLHelper.toXMLString(s)).append("/>");
        }
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void genQueuesInfo(HttpServletResponse response, VWSession curVWSession) throws Throwable {
        String m_method = "genQueuesInfo";
        String CALL_START_TAG = "<ListWorkQueuesCall";
        String CALL_END_TAG = "\n</ListWorkQueuesCall>";
        StringBuffer buf = new StringBuffer();
        PEAPIServletTest.GetGenericInfo(curVWSession, "<ListWorkQueuesCall", buf);
        int fetchFlag = 37;
        buf.append("fetchFlag=\"").append(fetchFlag).append("\" ");
        try {
            VWUserInfo user = curVWSession.fetchCurrentUserInfo();
            TimingInfo timer = new TimingInfo(null);
            String[] theList = curVWSession.fetchQueueNames(fetchFlag);
            String sTiming = timer.elapsed();
            int nItems = theList == null ? 0 : theList.length;
            buf.append(" user = \"").append(user.getName()).append("\" nitems=\"").append(nItems).append("\" ").append(sTiming).append(">");
            for (int i = 0; i < nItems; ++i) {
                buf.append("\n").append("<WorkQueue name=\"").append(XMLHelper.toXMLString(theList[i])).append("\"/>");
            }
            buf.append("\n</ListWorkQueuesCall>");
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            logger.severe(m_className, "genQueuesInfo", s);
            buf.append(" Exception=\"").append(XMLHelper.toXMLString(s)).append("/>");
        }
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void genRostersInfo(HttpServletResponse response, String cpName, VWSession curVWSession) throws Throwable {
        String m_method = "genRostersInfo";
        String CALL_START_TAG = "<ListRostersCall";
        String CALL_END_TAG = "\n</ListRostersCall>";
        StringBuffer buf = new StringBuffer();
        PEAPIServletTest.GetGenericInfo(curVWSession, "<ListRostersCall", buf);
        try {
            VWUserInfo user = curVWSession.fetchCurrentUserInfo();
            TimingInfo timer = new TimingInfo(null);
            String[] theList = curVWSession.fetchRosterNames(false);
            String sTiming = timer.elapsed();
            int nItems = theList == null ? 0 : theList.length;
            buf.append(" user = \"").append(user.getName()).append("\" nitems=\"").append(nItems).append("\" ").append(sTiming).append(">");
            for (int i = 0; i < nItems; ++i) {
                buf.append("\n").append("<Roster name=\"").append(XMLHelper.toXMLString(theList[i])).append("\"/>");
            }
            buf.append("\n</ListRostersCall>");
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            logger.severe(m_className, "genRostersInfo", s);
            buf.append(" Exception=\"").append(XMLHelper.toXMLString(s)).append("/>");
        }
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void transferTestWorkflowDefinition(HttpServletRequest request, HttpServletResponse response, VWSession curVWSession) throws Exception {
        String CALL_START_TAG = "<TransferTestWorkflowDefinitionCall";
        StringBuffer buf = new StringBuffer();
        PEAPIServletTest.GetGenericInfo(curVWSession, "<TransferTestWorkflowDefinitionCall", buf);
        try {
            String[] curWCs = curVWSession.fetchWorkClassNames(true);
            int nWC = curWCs == null ? 0 : curWCs.length;
            boolean noop = false;
            for (int i = 0; i < nWC && !noop; ++i) {
                if (!PEAPITEST_WF_NAME.equals(curWCs[i])) continue;
                buf.append(" noop=\"true\"/>");
                noop = true;
            }
            if (!noop) {
                TimingInfo timer = new TimingInfo(null);
                VWWorkflowDefinition theWorkflow = VWWorkflowDefinition.read(new ByteArrayInputStream(TEST_WORKFLOW_STRING.getBytes()));
                VWTransferResult tferErrors = curVWSession.transfer(theWorkflow, "\"QD\"", true, true);
                String sTiming = timer.elapsed();
                if (!tferErrors.success()) {
                    String[] errStrs = tferErrors.getErrors();
                    int nErrors = errStrs == null ? 0 : errStrs.length;
                    buf.append(" TransferErrors=\"");
                    for (int j = 0; j < nErrors; ++j) {
                        String s = errStrs[j].trim();
                        if (s.length() == 0) continue;
                        buf.append(s).append(" ");
                    }
                    buf.append("\" ");
                } else {
                    String newVWVersion = tferErrors.getVersion();
                    buf.append(" VWVersion=\"");
                    buf.append(XMLHelper.toXMLString(newVWVersion)).append("\" ");
                }
                buf.append(sTiming).append("/>");
            }
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            buf.append(" Exception=\"").append(XMLHelper.toXMLString(s)).append("\"/>");
        }
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void launchFunction(String workclassName, HttpServletRequest request, HttpServletResponse response, VWSession curVWSession, String cpName) throws Throwable {
        StringBuffer buf = new StringBuffer();
        int nItems = this.getIntParameter(request, PARAM_NITEMS, 5);
        Object[] fieldValues = new Object[WFFIELD_PEAPI_FIELDS_NUM];
        fieldValues[1] = new Date();
        fieldValues[0] = "PEAPIServetTest " + fieldValues[1].toString();
        fieldValues[2] = new Integer(100);
        buf.append("<LaunchWorkClassCall").append(" wc=\"").append(workclassName).append("\" cp=\"").append(cpName).append("\" nitems=\"").append(nItems).append("\" ");
        TimingInfo timer = new TimingInfo(null);
        try {
            VWCreateLiveWOResult[] result = curVWSession.createLiveWorkObject(WFFIELD_PEAPI_FIELDS, fieldValues, workclassName, nItems);
            buf.append(" ").append(timer.elapsed()).append(">");
            int nResults = result == null ? 0 : result.length;
            for (int i = 0; i < nResults; ++i) {
                buf.append("\n<VWCreateLiveWOResult ");
                if (result[i].success()) {
                    buf.append(" Status=\"ok\"");
                    buf.append(" RosterName=\"").append(result[i].getRosterName()).append("\" WOBNumber=\"").append(result[i].getWorkObjectNumber()).append("\"/>");
                    continue;
                }
                buf.append(" Status=\"failed\"");
                buf.append(" Error=\"").append(result[i].getErrorTuple()).append("\"/>");
            }
            buf.append("\n</LaunchWorkClassCall>");
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            buf.append(" ").append(timer.elapsed()).append(" Exception=\"").append(XMLHelper.toXMLString(s)).append("\"/>");
        }
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private static int getFetchType(HttpServletRequest request, int defaultType) {
        String s = request.getParameter(PARAM_FETCHTYPE);
        if (s != null) {
            if (s.equals("stepelement")) {
                return 5;
            }
            if (s.equals("workobject")) {
                return 1;
            }
        }
        return defaultType;
    }

    private static int getFunction(String function) {
        if (function != null) {
            for (int i = 0; i < FUNCTIONS.length; ++i) {
                if (!function.equals(FUNCTIONS[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private void doFunctions(int useType, String pathInfo, HttpServletRequest request, HttpServletResponse response, VWSession curVWSession, String user, String pw, String cpName, String ceuri) throws Throwable {
        int function = PEAPIServletTest.getFunction(pathInfo);
        switch (function) {
            case 0: {
                if (useType == 0) {
                    this.rosterQuery(request, response, curVWSession, cpName);
                    break;
                }
                if (useType != 1) break;
                this.queueQuery(request, response, curVWSession, cpName);
                break;
            }
            case 1: {
                if (useType == 0) {
                    this.rosterDispatch(request, response, curVWSession, user, pw, cpName, ceuri);
                    break;
                }
                if (useType != 1) break;
                this.queueDispatch(request, response, curVWSession, user, pw, cpName, ceuri);
                break;
            }
            case -1: {
                throw new Exception("Invalid request: " + pathInfo);
            }
        }
    }

    private static String convertDateToUTCString(Date theDate) {
        if (theDate == null || theDate.getTime() == NO_DATE.longValue()) {
            return "";
        }
        sdf.setTimeZone(pdt);
        String strDate2 = sdf.format(theDate);
        return strDate2;
    }

    private static void VWWorkObjectToXML(VWWorkObject wob, StringBuffer theBuffer) throws Exception {
        String tmpS;
        Date tmpD;
        String ATTRIB_INDENT = "\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWQueueElementNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("<WorkObject");
        VWParticipant tmpPar = wob.getOriginatorPx();
        if (tmpPar != null) {
            if (tmpPar.getDisplayName() != null) {
                theBuffer.append(ATTRIB_INDENT + "LaunchedBy=\"" + XMLHelper.toXMLString(tmpPar.getDisplayName()) + "\"\n");
            } else {
                theBuffer.append(ATTRIB_INDENT + "LaunchedBy=\"" + XMLHelper.toXMLString(tmpPar.getParticipantName()) + "\"\n");
            }
        }
        if ((tmpD = wob.getLaunchDate()) != null) {
            theBuffer.append(ATTRIB_INDENT + "LaunchedOn=\"" + XMLHelper.toXMLString(PEAPIServletTest.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpD = wob.getDateReceived()) != null) {
            theBuffer.append(ATTRIB_INDENT + "ReceivedOn=\"" + XMLHelper.toXMLString(PEAPIServletTest.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpD = wob.getDeadline()) != null) {
            theBuffer.append(ATTRIB_INDENT + "Deadline=\"" + XMLHelper.toXMLString(PEAPIServletTest.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpD = wob.getReminder()) != null) {
            theBuffer.append(ATTRIB_INDENT + "Reminder=\"" + XMLHelper.toXMLString(PEAPIServletTest.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpS = wob.getStepName()) != null) {
            theBuffer.append(ATTRIB_INDENT + "StepName=\"" + XMLHelper.toXMLString(tmpS) + "\"\n");
        }
        theBuffer.append(ATTRIB_INDENT + "WOBName=\"" + XMLHelper.toXMLString(wob.getWorkObjectName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WOBNumber=\"" + XMLHelper.toXMLString(wob.getWorkObjectNumber()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WorkflowName=\"" + XMLHelper.toXMLString(wob.getWorkflowName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WorkflowNumber=\"" + XMLHelper.toXMLString(wob.getWorkflowNumber()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WorkClassName=\"" + XMLHelper.toXMLString(wob.getWorkClassName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Tag=\"" + XMLHelper.toXMLString(wob.getTag()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "RosterName=\"" + XMLHelper.toXMLString(wob.getRosterName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "ParticipantName=\"" + XMLHelper.toXMLString(wob.getParticipantName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "OperationName=\"" + XMLHelper.toXMLString(wob.getOperationName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "ExceptionDescription=\"" + XMLHelper.toXMLString(wob.getExceptionDescription()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "IsTracker=\"" + (wob.getIsTracker() ? "true" : "false") + "\"\n");
        int overD = wob.getOverdue();
        theBuffer.append(ATTRIB_INDENT + "Overdue=");
        switch (overD) {
            case 0: {
                theBuffer.append("\"NotOverdue\"\n");
                break;
            }
            case 1: {
                theBuffer.append("\"ReminderPast\"\n");
                break;
            }
            case 2: {
                theBuffer.append("\"DeadlinePast\"\n");
                break;
            }
            default: {
                theBuffer.append("\"InvalidOverdueValue\"\n");
            }
        }
        theBuffer.append(">\n");
        theBuffer.append("<Fields");
        VWDataField[] df = wob.getDataFields(767, 3);
        if (df != null) {
            theBuffer.append(">\n");
            int arrayCount = df.length;
            for (int i = 0; i < arrayCount; ++i) {
                df[i].toXML(theBuffer);
            }
            theBuffer.append("</Fields>\n");
        } else {
            theBuffer.append("/>\n");
        }
        theBuffer.append("</WorkObject>\n");
    }

    private void rosterQuery(HttpServletRequest request, HttpServletResponse response, VWSession curVWSession, String cpName) throws Throwable {
        boolean wantXML = request.getParameter(PARAM_WANTXML) != null;
        TimingInfo timer = new TimingInfo(null);
        String name = this.getStringParameter(request, PARAM_NAME, PARAM_DEFAULT_ROSTER);
        int nItems = this.getIntParameter(request, PARAM_NITEMS, 100);
        VWRoster roster = curVWSession.getRoster(name);
        roster.setBufferSize(Math.min(nItems, 100));
        int queryFlags = 3;
        int fetchType = PEAPIServletTest.getFetchType(request, 4);
        if (fetchType == 5) {
            fetchType = 4;
        }
        String wobNum = request.getParameter(PARAM_WOBNUM);
        Object[] minValues = null;
        Object[] maxValues = null;
        String indexName = null;
        if (wobNum != null) {
            minValues = new Object[]{wobNum};
            maxValues = minValues;
            queryFlags += 96;
            indexName = PARAM_DEFAULT_INDEXNAME;
        }
        VWRosterQuery query = roster.createQuery(indexName, minValues, maxValues, queryFlags, null, null, fetchType);
        int count = query.fetchCount();
        int nDisplayed = Math.min(count, nItems);
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        switch (fetchType) {
            case 4: {
                buf.append("<RosterElements");
                break;
            }
            case 1: {
                buf.append("<WorkObjects");
            }
        }
        buf.append(" name=\"").append(name).append("\" system=\"").append(XMLHelper.toXMLString(curVWSession.getServerName())).append("\" region=\"").append(curVWSession.getIsolatedRegion()).append("\" nCount=\"").append(nDisplayed).append("\" ");
        StringBuffer buf2 = new StringBuffer();
        block12: for (int i = 0; i < nDisplayed; ++i) {
            switch (fetchType) {
                case 4: {
                    VWWorkElement wob = (VWRosterElement)query.next();
                    if (wantXML) {
                        ((VWRosterElement)wob).toXML(buf2);
                        continue block12;
                    }
                    buf2.append("<RosterElement i=\"").append(i).append("\" wob=\"").append(((VWRosterElement)wob).getWorkObjectNumber()).append("\"/>");
                    continue block12;
                }
                case 1: {
                    VWWorkElement wob = (VWWorkObject)query.next();
                    if (wantXML) {
                        PEAPIServletTest.VWWorkObjectToXML((VWWorkObject)wob, buf2);
                        continue block12;
                    }
                    buf2.append("<WorkObject i=\"").append(i).append("\" wob=\"").append(((VWWorkObject)wob).getWorkObjectNumber()).append("\"/>");
                    continue block12;
                }
            }
        }
        buf.append(timer.elapsed()).append(">").append(buf2);
        switch (fetchType) {
            case 4: {
                buf.append("</RosterElements>");
                break;
            }
            case 1: {
                buf.append("</WorkObjects>");
            }
        }
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void queueQuery(HttpServletRequest request, HttpServletResponse response, VWSession curVWSession, String cpName) throws Throwable {
        boolean wantXML = request.getParameter(PARAM_WANTXML) != null;
        String m_method = "queueQuery";
        logger.finest(m_className, "queueQuery", "1");
        TimingInfo timer = new TimingInfo(null);
        String name = this.getStringParameter(request, PARAM_NAME, PARAM_DEFAULT_QUEUE);
        int nItems = this.getIntParameter(request, PARAM_NITEMS, 100);
        logger.finest(m_className, "queueQuery", "2-getQueue");
        VWQueue queue = curVWSession.getQueue(name);
        queue.setBufferSize(Math.min(nItems, 100));
        int queryFlags = this.getIntParameter(request, PARAM_QUERYFLAGS, 1);
        int fetchType = PEAPIServletTest.getFetchType(request, 3);
        String wobNum = request.getParameter(PARAM_WOBNUM);
        Object[] minValues = null;
        Object[] maxValues = null;
        String indexName = null;
        if (wobNum != null) {
            minValues = new Object[]{wobNum};
            maxValues = minValues;
            queryFlags += 96;
            indexName = PARAM_DEFAULT_INDEXNAME;
        }
        logger.finest(m_className, "queueQuery", "3-createQuery");
        VWQueueQuery query = queue.createQuery(indexName, minValues, maxValues, queryFlags, null, null, fetchType);
        int nDisplayed = 0;
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        switch (fetchType) {
            case 3: {
                buf.append("<QueueElements");
                break;
            }
            case 1: {
                buf.append("<WorkObjects");
                break;
            }
            case 5: {
                buf.append("<StepElements");
            }
        }
        buf.append(" name=\"").append(name).append("\" system=\"").append(XMLHelper.toXMLString(curVWSession.getServerName())).append("\" region=\"").append(curVWSession.getIsolatedRegion()).append("\" queryflags=\"").append(queryFlags);
        StringBuffer buf2 = new StringBuffer();
        while (query.hasNext() && nDisplayed < nItems) {
            ++nDisplayed;
            switch (fetchType) {
                case 3: {
                    logger.finest(m_className, "queueQuery", "4a-query.next");
                    VWWorkElement wob = (VWQueueElement)query.next();
                    if (wantXML) {
                        ((VWQueueElement)wob).toXML(buf2);
                        break;
                    }
                    buf2.append("<QueueElement item=\"").append(nDisplayed).append("\" wob=\"").append(((VWQueueElement)wob).getWorkObjectNumber()).append("\" />\n");
                    break;
                }
                case 1: {
                    logger.finest(m_className, "queueQuery", "4b-query.next");
                    VWWorkElement wob = (VWWorkObject)query.next();
                    if (wantXML) {
                        PEAPIServletTest.VWWorkObjectToXML((VWWorkObject)wob, buf2);
                        break;
                    }
                    buf2.append("<WorkObject item=\"").append(nDisplayed).append("\" wob=\"").append(((VWWorkObject)wob).getWorkObjectNumber()).append("\" />\n");
                    break;
                }
                case 5: {
                    logger.finest(m_className, "queueQuery", "4c-query.next");
                    VWWorkElement wob = (VWStepElement)query.next();
                    if (wantXML) {
                        ((VWStepElement)wob).toXML(buf2);
                        break;
                    }
                    buf2.append("<StepElement item=\"").append(nDisplayed).append("\" wob=\"").append(((VWStepElement)wob).getWorkObjectNumber()).append("\" />\n");
                }
            }
        }
        buf.append("\" nCount=\"").append(nDisplayed).append("\" ");
        buf.append(timer.elapsed()).append(">").append(buf2);
        logger.finest(m_className, "queueQuery", "5-DONETIMING.");
        switch (fetchType) {
            case 3: {
                buf.append("</QueueElements>");
                break;
            }
            case 1: {
                buf.append("</WorkObjects>");
                break;
            }
            case 5: {
                buf.append("</StepElements>");
            }
        }
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void rosterDispatch(HttpServletRequest request, HttpServletResponse response, VWSession curVWSession, String user, String pw, String cpName, String ceuri) throws Throwable {
        TimingInfo timer;
        StringBuffer buf = new StringBuffer();
        String name = this.getStringParameter(request, PARAM_NAME, PARAM_DEFAULT_ROSTER);
        boolean optimize = request.getParameter(PARAM_OPTIMIZE) != null;
        String wobNum = request.getParameter(PARAM_WOBNUM);
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        buf.append("<RosterDispatchCall name=\"").append(name).append("\" user=\"").append(user).append("\" server=\"").append(curVWSession.getServerName()).append("\" region=\"").append(curVWSession.getIsolatedRegion()).append("\" cp=\"").append(cpName).append("\" ceuri=\"").append(ceuri).append("\" optimize=\"").append(optimize).append("\"");
        if (wobNum != null) {
            buf.append(" wobnum=\"").append(wobNum).append("\"");
            timer = new TimingInfo(null);
            WFRosterDispatchService worker = new WFRosterDispatchService(user, pw, cpName, ceuri, wobNum, name, 1, optimize, false);
            worker.run();
            buf.append(" ").append(timer.elapsed()).append(">");
            buf.append("\n").append(worker);
        } else {
            timer = new TimingInfo(null);
            VWRoster roster = curVWSession.getRoster(name);
            int nCount = roster.fetchCount();
            buf.append(" count=\"").append(nCount).append("\"");
            if (nCount == 0) {
                buf.append("\">");
            } else {
                int j;
                int nRealItems;
                int nItems = Math.min(this.getIntParameter(request, PARAM_NITEMS, 5), nCount);
                boolean concurrent = request.getParameter(PARAM_CONCURRENT) != null;
                buf.append(" nitems=\"").append(nItems).append("\"").append(" concurrent=\"").append(concurrent).append("\"");
                roster.setBufferSize(nItems);
                String[] wobList = new String[nItems];
                boolean[] lockedFlags = new boolean[nItems];
                int queryFlags = 3;
                int fetchType = 1;
                VWRosterQuery query = roster.createQuery(null, null, null, queryFlags, null, null, fetchType);
                for (nRealItems = 0; query.hasNext() && nRealItems < nItems; ++nRealItems) {
                    VWWorkObject vwobj = (VWWorkObject)query.next();
                    wobList[nRealItems] = vwobj.getWorkObjectNumber();
                    lockedFlags[nRealItems] = vwobj.getLockedUser() != null;
                }
                WFRosterDispatchService[] workers = new WFRosterDispatchService[nRealItems];
                Thread[] workerThreads = null;
                if (concurrent) {
                    workerThreads = new Thread[nRealItems];
                }
                for (j = 0; j < nRealItems; ++j) {
                    workers[j] = new WFRosterDispatchService(user, pw, cpName, ceuri, wobList[j], name, j, optimize, lockedFlags[j]);
                    if (concurrent) {
                        workerThreads[j] = new Thread(workers[j]);
                        workerThreads[j].setName("WFROSTERDISPATCH[" + j + "]");
                        continue;
                    }
                    workers[j].run();
                }
                if (concurrent) {
                    for (j = 0; j < nRealItems; ++j) {
                        workerThreads[j].start();
                    }
                    for (j = 0; j < nRealItems; ++j) {
                        workerThreads[j].join();
                    }
                }
                buf.append(" ").append(timer.elapsed()).append(">");
                for (j = 0; j < nRealItems; ++j) {
                    buf.append("\n").append(workers[j]);
                }
            }
        }
        buf.append("\n</RosterDispatchCall>");
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    private void queueDispatch(HttpServletRequest request, HttpServletResponse response, VWSession curVWSession, String user, String pw, String cpName, String ceuri) throws Throwable {
        TimingInfo timer;
        StringBuffer buf = new StringBuffer();
        String name = this.getStringParameter(request, PARAM_NAME, PARAM_DEFAULT_QUEUE);
        boolean optimize = request.getParameter(PARAM_OPTIMIZE) != null;
        String wobNum = request.getParameter(PARAM_WOBNUM);
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        buf.append("<QueueDispatchCall name=\"").append(name).append("\" user=\"").append(user).append("\" server=\"").append(curVWSession.getServerName()).append("\" region=\"").append(curVWSession.getIsolatedRegion()).append("\" cp=\"").append(cpName).append("\" ceuri=\"").append(ceuri).append("\" optimize=\"").append(optimize).append("\"");
        if (wobNum != null) {
            buf.append(" wobnum=\"").append(wobNum).append("\"");
            timer = new TimingInfo(null);
            WFQueueDispatchService worker = new WFQueueDispatchService(user, pw, cpName, ceuri, wobNum, name, 1, optimize, false);
            worker.run();
            buf.append(" ").append(timer.elapsed()).append(">");
            buf.append("\n").append(worker);
        } else {
            timer = new TimingInfo(null);
            VWQueue queue = curVWSession.getQueue(name);
            int nCount = queue.fetchCount();
            buf.append(" count=\"").append(nCount).append("\"");
            if (nCount == 0) {
                buf.append("\">");
            } else {
                int j;
                int nRealItems;
                int nItems = Math.min(this.getIntParameter(request, PARAM_NITEMS, 5), nCount);
                boolean concurrent = request.getParameter(PARAM_CONCURRENT) != null;
                buf.append(" nitems=\"").append(nItems).append("\"").append(" concurrent=\"").append(concurrent).append("\"");
                queue.setBufferSize(nItems);
                String[] wobList = new String[nItems];
                boolean[] lockedFlags = new boolean[nItems];
                int queryFlags = 3;
                int fetchType = 1;
                VWQueueQuery query = queue.createQuery(null, null, null, queryFlags, null, null, fetchType);
                for (nRealItems = 0; query.hasNext() && nRealItems < nItems; ++nRealItems) {
                    VWWorkObject vwobj = (VWWorkObject)query.next();
                    wobList[nRealItems] = vwobj.getWorkObjectNumber();
                    lockedFlags[nRealItems] = vwobj.getLockedUser() != null;
                }
                WFQueueDispatchService[] workers = new WFQueueDispatchService[nRealItems];
                Thread[] workerThreads = null;
                if (concurrent) {
                    workerThreads = new Thread[nRealItems];
                }
                for (j = 0; j < nRealItems; ++j) {
                    workers[j] = new WFQueueDispatchService(user, pw, cpName, ceuri, wobList[j], name, j, optimize, lockedFlags[j]);
                    if (concurrent) {
                        workerThreads[j] = new Thread(workers[j]);
                        workerThreads[j].setName("WFQUEUEDISPATCH[" + j + "]");
                        continue;
                    }
                    workers[j].run();
                }
                if (concurrent) {
                    for (j = 0; j < nRealItems; ++j) {
                        workerThreads[j].start();
                    }
                    for (j = 0; j < nRealItems; ++j) {
                        workerThreads[j].join();
                    }
                }
                buf.append(" ").append(timer.elapsed()).append(">");
                for (j = 0; j < nRealItems; ++j) {
                    buf.append("\n").append(workers[j]);
                }
            }
        }
        buf.append("\n</QueueDispatchCall>");
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    static {
        try {
            Class.forName("com.ibm.CORBA.iiop.ORB");
            ORBClassName = "com.ibm.CORBA.iiop.ORB";
        }
        catch (Throwable t) {
            ORB mOrb = ORB.init((String[])new String[0], null);
            ORBClassName = mOrb.getClass().getName();
        }
        G_LIST_PATHS = new String[]{"/listcp", "/listqueues", "/listrosters", "/listwc", "/list"};
        G_LIST_PATHS_HELP = new String[]{" == List Connection Points defined for Component Manager", " == List Queues", " == List Rosters", " == List Work classes transferred for the connection points", " == List Work classes -- same as listwc"};
        TEST_WORKFLOW_STRING = "<?xml version='1.0' encoding='UTF-8'?>" + LF + "<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">" + LF + "<WorkFlowDefinition ApiVersion=\"4.0\"" + LF + "Origin=\"JavaAPI\"" + LF + "\tSubject=\"&quot;" + PEAPITEST_WF_NAME + "&quot;\"" + LF + "\tDescription=\"Go to originator inbox...\"" + LF + "\tName=\"" + PEAPITEST_WF_NAME + "\"" + LF + "\tAuthorTool=\"Process Designer\"" + LF + "\tversionAgnostic=\"false\"" + LF + "\tvalidateUsingSchema=\"true\"" + LF + "\tvalidateFlag=\"true\"" + LF + "\ttransferFlag=\"true\">" + LF + "\t<Field" + LF + "\t\tName=\"peapiString\"" + LF + "\t\tValueExpr=\"&quot;&quot;\"" + LF + "\t\tType=\"string\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Field" + LF + "\t\tName=\"peapiDate\"" + LF + "\t\tValueExpr=\"systemtime()\"" + LF + "\t\tType=\"time\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Field" + LF + "\t\tName=\"peapiInteger\"" + LF + "\t\tValueExpr=\"0\"" + LF + "\t\tType=\"int\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Map" + LF + "\t\tName=\"Workflow\"" + LF + "\t\tMaxStepId=\"5\" >" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"0\"" + LF + "\t\t\tName=\"LaunchStep\"" + LF + "\t\t\tXCoordinate=\"50\"" + LF + "\t\t\tYCoordinate=\"50\"" + LF + "\t\t\tRequestedInterface=\"Approval Launch HTML (FileNet)\"" + LF + "\t\t\tJoinType=\"none\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "<Parameter" + LF + "\tName=\"peapiString\"" + LF + "\tValueExpr=\"peapiString\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiInteger\"" + LF + "\tValueExpr=\"peapiInteger\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiDate\"" + LF + "\tValueExpr=\"peapiDate\"" + LF + "\tType=\"time\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<Route" + LF + "\t\t\t\tSourceStepId=\"0\"" + LF + "\t\t\t\tDestinationStepId=\"3\"" + LF + "\t\t\t\tRouteId=\"0\"/>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"1\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"3\"" + LF + "\t\t\tName=\"Step1\"" + LF + "\t\t\tXCoordinate=\"196\"" + LF + "\t\t\tYCoordinate=\"50\"" + LF + "\t\t\tRequestedInterface=\"Approval HTML (FileNet)\"" + LF + "\t\t\tQueueName=\"Inbox\"" + LF + "\t\t\tJoinType=\"or\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "\t\t\t<Participant Val=\"F_Originator\" />" + LF + "<Parameter" + LF + "\tName=\"peapiString\"" + LF + "\tValueExpr=\"peapiString\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiInteger\"" + LF + "\tValueExpr=\"peapiInteger\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiDate\"" + LF + "\tValueExpr=\"peapiDate\"" + LF + "\tType=\"time\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<Route" + LF + "\t\t\t\tSourceStepId=\"3\"" + LF + "\t\t\t\tDestinationStepId=\"5\"" + LF + "\t\t\t\tRouteId=\"1\"/>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"2\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"5\"" + LF + "\t\t\tName=\"Step2\"" + LF + "\t\t\tXCoordinate=\"361\"" + LF + "\t\t\tYCoordinate=\"49\"" + LF + "\t\t\tRequestedInterface=\"Approval HTML (FileNet)\"" + LF + "\t\t\tQueueName=\"Inbox\"" + LF + "\t\t\tJoinType=\"or\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "\t\t\t<Participant Val=\"F_Originator\" />" + LF + "<Parameter" + LF + "\tName=\"peapiString\"" + LF + "\tValueExpr=\"peapiString\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiInteger\"" + LF + "\tValueExpr=\"peapiInteger\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiDate\"" + LF + "\tValueExpr=\"peapiDate\"" + LF + "\tType=\"time\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"2\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t</Map>" + LF + "</WorkFlowDefinition>";
        WFFIELD_PEAPI_FIELDS = new String[]{"peapiString", "peapiDate", "peapiInteger"};
        WFFIELD_PEAPI_FIELDS_NUM = WFFIELD_PEAPI_FIELDS.length;
        FUNCTIONS = new String[]{"query", "dispatch"};
        sdf = new SimpleDateFormat(UTC_ISO_DateMask);
        pdt = new SimpleTimeZone(0, "UTC");
        NO_DATE = new Long("-2000000000000");
    }

    class TimingInfo {
        private long startTime;
        private long endTime;
        private boolean stopped = false;
        private String desc = "timingInfo";

        protected TimingInfo(String desc) {
            if (desc != null && desc.trim().length() != 0) {
                this.desc = desc;
            }
            this.start();
        }

        protected void start() {
            this.startTime = System.currentTimeMillis();
            this.stopped = false;
        }

        protected void stop() {
            this.endTime = System.currentTimeMillis();
            this.stopped = true;
        }

        protected String elapsed() {
            if (!this.stopped) {
                this.stop();
            }
            long elapsed = this.endTime - this.startTime;
            return this.desc + "=\"" + elapsed + "ms\"";
        }
    }

    class WFQueueDispatchService
    implements Runnable {
        private String user;
        private String pw;
        private String cpName;
        private String ceuri;
        private String wobnum;
        private String name;
        private int id;
        private String m_desc = null;
        private boolean optimize = false;
        private boolean alreadyLocked = false;

        protected WFQueueDispatchService(String user, String pw, String cpName, String ceuri, String wobnum, String name, int id, boolean optimize, boolean alreadyLocked) {
            this.user = user;
            this.pw = pw;
            this.cpName = cpName;
            this.ceuri = ceuri;
            this.wobnum = wobnum;
            this.name = name;
            this.id = id;
            this.optimize = optimize;
            this.alreadyLocked = alreadyLocked;
        }

        private VWWorkObject getWorkObject(VWSession vwses, StringBuffer buf) throws VWException {
            int queryFlags;
            Object[] minValue = new Object[]{this.wobnum.trim()};
            Object[] maxValue = new Object[]{this.wobnum.trim()};
            VWWorkObject vwobj = null;
            VWQueue queue = vwses.getQueue(this.name);
            VWQueueQuery query = queue.createQuery(PEAPIServletTest.PARAM_DEFAULT_INDEXNAME, minValue, maxValue, queryFlags = 99, null, null, 1);
            if (query.hasNext()) {
                vwobj = (VWWorkObject)query.next();
                buf.append(" getWorkObject=\"true\"");
            } else {
                buf.append(" getWorkObject=\"false\"");
            }
            return vwobj;
        }

        private void setDataFields(VWWorkObject vwobj, StringBuffer buf) {
            if (vwobj == null) {
                return;
            }
            Object[] fieldValues = new Object[WFFIELD_PEAPI_FIELDS_NUM];
            fieldValues[1] = new Date();
            fieldValues[0] = "PEAPIServetTest dispatched by queue/dispatch#" + this.id + ", " + Thread.currentThread().getName() + fieldValues[1].toString();
            fieldValues[2] = new Integer(1000 + this.id);
            for (int i = 0; i < WFFIELD_PEAPI_FIELDS_NUM; ++i) {
                try {
                    String fName = WFFIELD_PEAPI_FIELDS[i];
                    Object fValue = fieldValues[i];
                    vwobj.setFieldValue(fName, fValue, false);
                    buf.append(" ").append(fName).append("=\"").append(XMLHelper.toXMLString(fValue.toString())).append("\"");
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }

        public void run() {
            String threadId = Thread.currentThread().getName();
            TimingInfo timer = new TimingInfo(null);
            StringBuffer buf = new StringBuffer();
            try {
                buf.append("<WFQueueDispatchService id=\"").append(this.id).append("\" tId=\"").append(threadId).append("\" wobnum=\"").append(this.wobnum).append("\" optimize=\"").append(this.optimize).append("\" alreadyLocked=\"").append(this.alreadyLocked).append("\" ");
                VWSession vwses = new VWSession();
                vwses.setBootstrapCEURI(this.ceuri);
                vwses.logon(this.user, this.pw, this.cpName);
                VWWorkObject vwobj = this.getWorkObject(vwses, buf);
                if (vwobj != null) {
                    vwobj.doLock(true);
                    buf.append(" doLock=\"ok\"");
                    this.setDataFields(vwobj, buf);
                    if (!this.optimize) {
                        vwobj.doSave(false);
                        buf.append(" doSave=\"ok\"");
                    }
                    vwobj.doDispatch();
                    buf.append(" doDispatch=\"ok\"");
                }
            }
            catch (Throwable t) {
                buf.append(" runException=\"").append(XMLHelper.toXMLString(VWException.DescribeThrowableCompletely(t))).append("\"");
            }
            buf.append(" ").append(timer.elapsed()).append(" />");
            this.m_desc = buf.toString();
        }

        public String toString() {
            return this.m_desc;
        }
    }

    class WFRosterDispatchService
    implements Runnable {
        private String user;
        private String pw;
        private String cpName;
        private String ceuri;
        private String wobnum;
        private String name;
        private int id;
        private String m_desc = null;
        private boolean optimize = false;
        private boolean alreadyLocked = false;

        protected WFRosterDispatchService(String user, String pw, String cpName, String ceuri, String wobnum, String name, int id, boolean optimize, boolean alreadyLocked) {
            this.user = user;
            this.pw = pw;
            this.cpName = cpName;
            this.ceuri = ceuri;
            this.wobnum = wobnum;
            this.name = name;
            this.id = id;
            this.optimize = optimize;
            this.alreadyLocked = alreadyLocked;
        }

        private VWWorkObject getWorkObject(VWSession vwses, StringBuffer buf) throws VWException {
            int queryFlags;
            Object[] minValue = new Object[]{this.wobnum.trim()};
            Object[] maxValue = new Object[]{this.wobnum.trim()};
            VWWorkObject vwobj = null;
            VWRoster roster = vwses.getRoster(this.name);
            VWRosterQuery query = roster.createQuery(PEAPIServletTest.PARAM_DEFAULT_INDEXNAME, minValue, maxValue, queryFlags = 99, null, null, 1);
            if (query.hasNext()) {
                vwobj = (VWWorkObject)query.next();
                buf.append(" getWorkObject=\"true\"");
            } else {
                buf.append(" getWorkObject=\"false\"");
            }
            return vwobj;
        }

        private void setDataFields(VWWorkObject vwobj, StringBuffer buf) {
            if (vwobj == null) {
                return;
            }
            Object[] fieldValues = new Object[WFFIELD_PEAPI_FIELDS_NUM];
            fieldValues[1] = new Date();
            fieldValues[0] = "PEAPIServetTest dispatched by roster/dispatch#" + this.id + ", " + fieldValues[1].toString();
            fieldValues[2] = new Integer(1000 + this.id);
            for (int i = 0; i < WFFIELD_PEAPI_FIELDS_NUM; ++i) {
                try {
                    String fName = WFFIELD_PEAPI_FIELDS[i];
                    Object fValue = fieldValues[i];
                    vwobj.setFieldValue(fName, fValue, false);
                    buf.append(" ").append(fName).append("=\"").append(XMLHelper.toXMLString(fValue.toString())).append("\"");
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }

        public void run() {
            String threadId = Thread.currentThread().getName();
            TimingInfo timer = new TimingInfo(null);
            StringBuffer buf = new StringBuffer();
            try {
                buf.append("<WFRosterDispatchService id=\"").append(this.id).append("\" tId=\"").append(threadId).append("\" wobnum=\"").append(this.wobnum).append("\" optimize=\"").append(this.optimize).append("\" alreadyLocked=\"").append(this.alreadyLocked).append("\" ");
                VWSession vwses = new VWSession();
                vwses.setBootstrapCEURI(this.ceuri);
                vwses.logon(this.user, this.pw, this.cpName);
                VWWorkObject vwobj = this.getWorkObject(vwses, buf);
                if (vwobj != null) {
                    vwobj.doLock(true);
                    buf.append(" doLock=\"ok\"");
                    this.setDataFields(vwobj, buf);
                    if (!this.optimize) {
                        vwobj.doSave(false);
                        buf.append(" doSave=\"ok\"");
                    }
                    vwobj.doDispatch();
                    buf.append(" doDispatch=\"ok\"");
                }
            }
            catch (Throwable t) {
                buf.append(" runException=\"").append(XMLHelper.toXMLString(VWException.DescribeThrowableCompletely(t))).append("\"");
            }
            buf.append(" ").append(timer.elapsed()).append(" />");
            this.m_desc = buf.toString();
        }

        public String toString() {
            return this.m_desc;
        }
    }
}

